# 📺 Æapp - Live Chat Archive

![Python](https://img.shields.io/badge/Python-3.11-blue)
![Flask](https://img.shields.io/badge/Flask-Web%20Framework-green)
![Made by Pia](https://img.shields.io/badge/Made%20by-P.Lenasdotter-ff69b4)

A Flask-based project that retrieves, filters, and archives live comments from YouTube Live Chat. Comments are stored in a SQLite database and can be viewed by day, week, or month - with visitor tracking and JSON API endpoints.

---

## 📥 Download NaetureLog

Ready to explore nature your way?  
Download the latest version of NaetureLog as a zip file below:

👉 [Download NaetureLog v1.0.0](https://aeapp.netlify.app/)

NaetureLog is a simple, joyful app for logging your nature experiences — built with love and curiosity 🌿

---

## 🚀 Features

✅ Fetches live comments from YouTube via API  
✅ Filters comments based on keywords  
✅ Stores comments in a SQLite database  
✅ Displays archives by day, week, and month  
✅ Provides JSON API endpoints  
✅ Tracks visitors based on IP address  
✅ Includes a reset function for the database  

---

## 🧰 Technologies Used

| Language / Tool       | Version / Usage             |
|-----------------------|-----------------------------|
| Python                | 3.11                        |
| Flask                 | Web framework               |
| SQLite                | Local database              |
| Docker                | Containerization            |
| YouTube Data API v3   | Fetching live comments      |
| HTML + Jinja2         | Templating engine           |

---

## 🐳 Getting Started with Docker

1. **Clone the project**  
   ```bash
   git clone https://github.com/yourname/yourrepo.git
   cd flask-projekt

2. **Create a .env file**
   ```env
   YOUTUBE_API_KEY=your_api_key  
   LIVE_CHAT_ID=your_live_chat_id  
   FILTER_KEYWORD=Ææ

3. **Start the app**
   docker compose up

4. **Visit the app**
   http://localhost:5000

---

## 📦 Dependencies
Listed in requirements.txt:
- flask
- requests
- python-dateutil
- gunicorn

---

## 🌍 Routes Overview

| Route                 | Description                    |
|-----------------------|--------------------------------|
| /home                 | Homepage with live comments    |
| /comments             | JSON API for today's comments  |
| /archive/by_month     | Comments grouped by month      |
| /archive/by_week      | Comments grouped by week       |
| /get_weeks            | API for weeks in selected month|
| /reset                | Clears the database            |
| /ping                | Test endpoint                  |

---

## 🧪 Run Locally Without Docker

1. **Install dependencies**
   ```bash
   pip install -r requirements.txt

2. **Run the app**
   ```bash
   flask run --host=0.0.0.0
   
---

## 🧼 Reset the Database
 Visit /reset to clear all stored comments and visitor logs.

---

## 📜 Licensing Overview
Æapp includes multiple license documents for clarity:
- EULA.pdf – End User License Agreement
- LICENSE_COMMERCIAL – Commercial use terms
- LICENSE – Personal use terms

Æapp is intended for respectful and thoughtful use. Please refer to the EULA for details.

---

## About Æapp
👉 [Read more about Æapp here](./WELCOME.md)

---

## 🌿 Join the Æapp Community
Visit our [FreeFlarum Discussions](https://naeturelog.freeflarum.com/) to:
- Ask for help
- Share ideas
- Report bugs
- Connect with other users

No pressure. No expectations. Just a space to explore Æapp together.

---


## 🏅 Credits
This app was created by P Lenasdotter – with curiosity, care, and a dash of Æ.  
Powered by thoughtful guidance from the best **Copilot** 💚 in the world.

---

🧪 Æapp is currently in early public preview. We’re exploring, improving, and evolving — with input from the community.
